'Version 2.0 May 2015 Taken over WIA repeater file creation
'Version 1.5 Dec 2013 Created LongLat Merge Version and improved handling of Notes
'Version 1.4 Sept 2013 Callsign filtering bug. 1 call area filter now works
'Version 1.3 Feb 2013 Script now ignores blank lines
'Version 1.2 July 2012 Added the /f filter to limit output to a list of states
'Version 1.1 June 2012 Fixed mismatched header columns and repeater columns, Added another sections
'Version 1.0 March 2012 - Original
'Copyright (c) Steve Ireland 2012
'WiaRep2ID880.vbs and all other variants that start with WiaRep2 were originaly written by Steve Ireland VK2MD (vk2md@wia.org.au)
'This application can be freely distributed, modified and used by anybody for both private and commercial purposes.

'If you make changes to the software please add the statements above to your source code to achnowledge Steve Ireland VK2MD as the original author and to freely 
'distribute your software.
'Please Please Please do not use the file name prefix WiaRep2 or WiaRepTo as I use this prefix on software that I maintain.
'In essance the naming convention is the only intellectual property that I assert purely for maintenance purposes.
'Have fun. Steve March 2012


'This script will read the WIA Repeater Directory CSV file and create a number of ID880 csv files that can be imported byCS/880

'//Nologo  //X .\Scripts\WiaRep2ID880.vbs ".\production\Repeater Directory Master.csv"  ".\production\temp\id880\id880.csv"


'To run this script 
'   cscript WiaRep2ID880.vbs "Repeater Directory 120214.csv" id880.csv
'   use the /c option to combine the output scripts
'   use the /f option to filter on states. eg /f:vk1,vk2,vk3 will only output repeaters from the listed states
 
Option Explicit
Dim args
Const ForReading = 1, ForWriting = 2, ForAppending = 8
Main

Sub Main()
    If ParseArgs() < 2 Then
        wscript.echo "Usage: cscript WiaRep2ID880.vbs ""WIA Repeater Directory ????.csv"" id880.csv"
        wscript.echo "       Use option /c to concatenate band files"
        wscript.echo "       Use option /f to filter states"
        Exit Sub
    End If


    'Go load the WIA repeater file using the passed in file name in arg0
    Dim bands
    bands = LoadWia(args("arg0"))

    'The WIA repeater csv will evolve over time so just test how big it is wrt the size it was when the script was developed
    If Not (UBound(bands) = 34 or UBound(bands) = 42) Then
        wscript.echo "Warning. The number of band sections in the WIA script has changed."
        wscript.echo "The script will try to continue but may miss out the extra data or crash."
    End If

    SaveID880 args("arg1"), bands

End Sub

'parses the arguments passed in and places them in a global dictionary for easy access
Function ParseArgs
    Dim namelessCount
    namelessCount = 0
    set args = CreateObject("Scripting.Dictionary") 'args are global

    Dim i
    For i=0 to WScript.Arguments.Count - 1
        Dim arg
        arg = WScript.Arguments.Item(i)
        If Left(arg,1) = "/" Or Left(arg,1) = "-" Then
            arg = Replace(arg,"/","")
            arg = Replace(arg,"-","")
            arg = Trim(arg)
            Dim parts
            parts = Split(arg,":")
            If UBound(parts) = 0 Then
                args.Add parts(0),""
            Else
                args.Add parts(0),parts(1)
            End If
        Else
            args.Add "arg" & CStr(namelessCount),arg
            namelessCount = namelessCount + 1
        End If
    Next

    ParseArgs = WScript.Arguments.Count
End Function

'Load the WIA CSV file into memory
'Returns a list of bands, that contains a list of repeaters. Each repeater entry is a dictionary
' eg bands(3)(32)("Call") will go to section 3, repeater number 32 and retrieve the Call entry as a string. Cool!
Function LoadWia(sourceCSV)
    Dim bands()
    LoadWia = bands

    Dim fso 
    set fso = CreateObject("Scripting.FileSystemObject")

    Dim file
    Set file = fso.OpenTextFile(sourceCSV, ForReading)
    If file.AtEndOfStream Then
        Exit Function
    End If

    'read in the header and get rid of all those extra quotes
    Dim header
    Dim i
    header = Split(Trim(Replace(file.ReadLine,"""","")),",") 
    For i=0 To UBound(header)
       header(i) = Trim(header(i)) 'Another Trim as one of the headers has an extra space at the end :-)
    Next

    'test that it is a WIA repeater file
    If header(0) <> "Output" And header(1) <> "Input" And header(2) <> "Call" Then
        wscript.echo sourceCSV & " is not a WIA repeater CSV file"
        Exit Function
    End If

    'read first line as it is a band seperator with commas everywhere and gives band information
    Dim bandSeparator
    bandSeparator = Split(Trim(Replace(file.ReadLine,"""","")),",")

    'load up every band
    Dim numBands
    numBands=0
    Do While file.AtEndOfStream <> True
        Dim band
        band = LoadWiaBand(file, header, bandSeparator)
        ReDim Preserve bands(numBands) 'expand the list
        bands(numBands) = band
        numBands = numBands + 1
    Loop
    file.Close

    LoadWia = bands 'return the whole structure
End Function


Function LoadWiaBand(file, header, bandSeparator)
    Dim repeater
    Dim repeaterDict
    Dim numRepeaters
    Dim band()

    numRepeaters = 0
    Do While file.AtEndOfStream <> True
        repeater = Split(Trim(Replace(file.ReadLine,"""","")),",") 'read in a repeater line from the file and split on a ,
        If UBound(repeater) > 2 Then 'skip illegal lines
            Dim i
            For i=0 To UBound(repeater) 'Trim up every field
               repeater(i) = Trim(repeater(i))
            Next
            'each band is seperated by and empty row
            If repeater(0) = "" And repeater(1) ="" And repeater(2) = "" Then
                bandSeparator = repeater
                LoadWiaBand = band
                Exit Function
            End If

            'create a repeater dictionary for each row keyed on the header
            set repeaterDict = CreateObject("Scripting.Dictionary")
            For i=0 to UBound(header)
                If i <= UBound(repeater) Then
                    If i < UBound(header) Then
                        repeaterDict.Add header(i), repeater(i) 
                    Else 'The note field can have extra , so we need to recombine them
                        Dim noteLine
                        noteLine = ""
                        Dim j
                        For j=i to UBound(repeater)
                            noteLine = noteLine & repeater(j) & ","
                        Next
                        noteLine = Left(noteLine,Len(noteLine)-1)
                        repeaterDict.Add header(i), noteLine 
                    End If
                Else
                    printMismatch(header)
                    printMismatch(repeater)
                    wscript.echo "Repeater has incorrect number of columms compared to header and has been skipped"
                    wscript.echo
                End If
            Next

            repeaterDict.Add "Tag",bandSeparator(14)
                            
            'Into the band list goes the repeater dictionary
            ReDim Preserve band(numRepeaters)
            set band(numRepeaters) = RepeaterDict
            numRepeaters = numRepeaters + 1
        End If
    Loop
    LoadWiaBand = band
End Function

Sub printMismatch(entry)
    Dim Line
    Line = ""
    Dim i
    For i=0 to UBound(entry)
        Line = Line & entry(i) & ", "
    Next
    wscript.echo Line
End Sub





'ID880 Section
'Converts the WIA repeater csv to equivilent ID880 csv's

'Only save the bands we need
Sub SaveID880(filename, bands)
    SaveID880VHF filename, bands
    SaveID880UHF filename, bands
    SaveID880DStar filename, bands
End Sub

Sub SaveID880VHF(filename, bands)

    wscript.echo
    wscript.echo "Generating VHF Files"

    const bandType = "vhf"
    const bandStart = 7 'vhfbands are 7 to 13 when this was written. It may change!
    const bandEnd = 13
    const callSuffix = "2"

    SaveID880FM filename, bands, bandType, bandStart, bandEnd, callSuffix

End Sub

Sub SaveID880UHF(filename, bands)
    wscript.echo
    wscript.echo "Generating UHF Files"

    const bandType = "uhf"
    const bandStart = 14 'uhfbands are 14 to 20 when this was written. It may change!
    const bandEnd = 20
    const callSuffix = "7"

    SaveID880FM filename, bands, bandType, bandStart, bandEnd, callSuffix

End Sub

Sub SaveID880DStar(filename, bands)
    wscript.echo
    wscript.echo "Generating DStar Files"

    const bandType = "ds"
    const bandStart = 26 'dstarbands are 25 to 30 when this was written. It may change!
    const bandEnd = 32

    SaveID880DV filename, bands, bandType, bandStart, bandEnd

End Sub


Sub SaveID880FM(filename, bands, bandType, loopStart, loopEnd, callSuffix)

    'initialised locals
    Dim chNo
    chNo = 0
    Dim fileCount
    fileCount=0
    Dim file
    Set file = Nothing
    dim onlyOnce
    onlyOnce = False
    const entriesPerCSV = 90 'write only 90 entries to the csv file leaving 10 spare for manual entries

    Dim fso 
    set fso = CreateObject("Scripting.FileSystemObject")
 
    'uninitialised locals
    Dim Line
    Dim i
    For i=loopStart to loopEnd 
        Dim repeater
        For Each repeater in bands(i)

            If RepeaterCallsignInFilter(repeater) = True Then

                If chNo Mod entriesPerCSV = 0 And onlyOnce = False Then

                    If args.Exists("c") Then 'if the combine arg is on the put all entries in the first file only
                        onlyOnce = True
                    End if

                    'If we have a file open then close it and flush the buffers
                    If Not file is Nothing Then
                        padoutTo100Lines file, 100-entriesPerCSV
                        file.Close()
                    End If

                    'Create the filename
                    Dim fileParts
                    Dim newFileName
                    fileParts = Split(filename,".")
                    newFilename = fileParts(0) & bandType & CStr(fileCount) & "." & fileParts(1)

                    'Delete the old file (if it exists) and create a new
                    On Error Resume Next
                    fso.DeleteFile(newFilename)
                    On Error goto 0
                    Set file = fso.CreateTextFile(newFilename)

                    wscript.echo "Created File " & newFilename

                    fileCount = fileCount + 1

                    'Write the header and save
                    Line = WriteID880Header
                    file.WriteLine(Line)
                End If

                'test to make sure that input and output frequencies are within the radios range, otherwise skip
                'There is a 10m repeater with a 2m output freq
                If (    ((CDbl(repeater("Output")) >= 144.0 And CDbl(repeater("Output")) < 148.0) Or (CDbl(repeater("Output")) >= 420.0 And CDbl(repeater("Output")) < 450.0)) And _
                        ((CDbl(repeater("Input")) >= 144.0 And CDbl(repeater("Input")) < 148.0) Or (CDbl(repeater("Input")) >= 420.0 And CDbl(repeater("Input")) < 450.0)) _
                   ) Then
            
                    'write each field into a string
                    Line = WriteID880Channel(CStr(chNo Mod entriesPerCSV))
                    Line = Line & WriteID880Frequency(repeater("Output"))
                    Line = Line & WriteID880Dup(repeater("Output"), repeater("Input"))
                    Line = Line & WriteID880Offset(repeater("Output"), repeater("Input"))
                    Line = Line & WriteID880TS("5kHz")
                    Line = Line & WriteID880Mode("FM")
                    Line = Line & WriteID880Name(repeater("Call"),callSuffix)
                    Line = Line & WriteID880Skip()
                    Line = Line & WriteID880Tone(repeater("Tone"))
                    Line = Line & WriteID880RepeaterTone(repeater("Tone"))
                    Line = Line & WriteID880TSQFreq()
                    Line = Line & WriteID880DTCSCode()
                    Line = Line & WriteID880DTCSPolarity()
                    Line = Line & WriteID880DTCSDVSQL()
                    Line = Line & WriteID880DTCSDVSQLCode()
                    Line = Line & WriteID880YourCallSign()
                    Line = Line & WriteID880RPT1CallSign("")
                    Line = Line & WriteID880RPT2CallSign("")
                    'Write to the file
                    file.WriteLine(Line)
                    Wscript.StdOut.Write "."
                    chNo = chNo + 1
                End If
            End If
        Next
    Next

    If chNo Mod entriesPerCSV = 0 Then
        padoutTo100Lines file, 100 - entriesPerCSV
    Else
        padoutTo100Lines file, 100 - (chNo Mod entriesPerCSV)
    End if

    file.Close()
    wscript.echo
    wscript.echo CStr(chNo) & " " & bandType & " repeaters processed"

End Sub

Sub SaveID880DV(filename, bands, bandType, loopStart, loopEnd)

    'initialised locals
    Dim chNo
    chNo = 0
    Dim fileCount
    fileCount=0
    Dim file
    Set file = Nothing
    dim onlyOnce
    onlyOnce = False
    const entriesPerCSV = 90 'write only 90 entries to the csv file leaving 10 spare for manual entries

    Dim fso 
    set fso = CreateObject("Scripting.FileSystemObject")
 
    'uninitialised locals
    Dim Line
    Dim i
    For i=loopStart to loopEnd 
        Dim repeater
        For Each repeater in bands(i)

            If RepeaterCallsignInFilter(repeater) = True Then

                If chNo Mod entriesPerCSV = 0 And onlyOnce = False Then

                    If args.Exists("c") Then 'if the combine arg is on the put all entries in the first file only
                        onlyOnce = True
                    End if

                    'If we have a file open then close it and flush the buffers
                    If Not file is Nothing Then
                        padoutTo100Lines file, 100 - entriesPerCSV 
                        file.Close()
                    End If

                    'Create the filename
                    Dim fileParts
                    Dim newFileName
                    fileParts = Split(filename,".")
                    newFilename = fileParts(0) & bandType & CStr(fileCount) & "." & fileParts(1)

                    'Delete the old file (if it exists) and create a new
                    On Error Resume Next
                    fso.DeleteFile(newFilename)
                    On Error goto 0
                    Set file = fso.CreateTextFile(newFilename)

                    wscript.echo "Created File " & newFilename

                    fileCount = fileCount + 1

                    'Write the header and save
                    Line = WriteID880Header
                    file.WriteLine(Line)
                End If

                'test to make sure that input and output frequencies are within the radios range, otherwise skip
                'dstar section contains 23cm frequencies
                If (    ((CDbl(repeater("Output")) >= 144.0 And CDbl(repeater("Output")) < 148.0) Or (CDbl(repeater("Output")) >= 420.0 And CDbl(repeater("Output")) < 450.0)) And _
                        ((CDbl(repeater("Input")) >= 144.0 And CDbl(repeater("Input")) < 148.0) Or (CDbl(repeater("Input")) >= 420.0 And CDbl(repeater("Input")) < 450.0)) _
                   ) Then

                    'write each field into a string
                    Line = WriteID880Channel(CStr(chNo Mod entriesPerCSV))
                    Line = Line & WriteID880Frequency(repeater("Output"))
                    Line = Line & WriteID880Dup(repeater("Output"), repeater("Input"))
                    Line = Line & WriteID880Offset(repeater("Output"), repeater("Input"))
                    Line = Line & WriteID880TS("5kHz")
                    Line = Line & WriteID880Mode("DV") 'different to FM
                    Line = Line & WriteID880Name(repeater("Call"),"")
                    Line = Line & WriteID880Skip()
                    Line = Line & WriteID880Tone(repeater("Tone"))
                    Line = Line & WriteID880RepeaterTone(repeater("Tone"))
                    Line = Line & WriteID880TSQFreq()
                    Line = Line & WriteID880DTCSCode()
                    Line = Line & WriteID880DTCSPolarity()
                    Line = Line & WriteID880DTCSDVSQL()
                    Line = Line & WriteID880DTCSDVSQLCode()
                    Line = Line & WriteID880YourCallSign()
                    Line = Line & WriteID880RPT1CallSign(expandCallSign(repeater("Call"),"")) 'different to FM
                    Line = Line & WriteID880RPT2CallSign(expandCallSign(repeater("Call"),"G")) 'Force a G on the end as RPT2
                    'Write to the file
                    file.WriteLine(Line)
                    Wscript.StdOut.Write "."
                    chNo = chNo + 1
                End if
            End If
        Next
    Next

    If chNo Mod entriesPerCSV = 0 Then
        padoutTo100Lines file, 100 - entriesPerCSV
    Else
        padoutTo100Lines file, 100 - (chNo Mod entriesPerCSV)
    End if

    file.Close()
    wscript.echo
    wscript.echo CStr(chNo) & " " & bandType & " repeaters processed"

End Sub

Function RepeaterCallsignInFilter(repeater)
     If Not args.Exists("f") Then 
         RepeaterCallsignInFilter = True
         Exit Function
     End If

    Dim parts
    parts = Split(args("f"),",")
    If UBound(parts) = -1 Then
         RepeaterCallsignInFilter = True
         Exit Function
    End If

    Dim i
    For i=0 to UBound(parts)
        If InStr(UCase(repeater("Call")),UCase(parts(i))) <> 0 Then
            RepeaterCallsignInFilter = True
            Exit Function
        End If
    Next

    RepeaterCallsignInFilter = False

End Function

'ID880 Support files
'They create the ID880 fields by converting the WIA fields


Function WriteID880Header
    WriteID880Header = "CH No,Frequency,Dup,Offset,TS,Mode,Name,SKIP,TONE,Repeater Tone,TSQL Frequency,DTCS Code,DTCS Polarity,DV SQL,DV CSQL Code,Your Call Sign,RPT1 Call Sign,RPT2 Call Sign"
End Function

Function WriteID880Channel(chNo)

    WriteID880Channel = Right("00" & chNo,2) & ","
End Function

Function WriteID880Frequency(freq)
    WriteID880Frequency = FormatNumber(CSng(freq),6,vbTrue,vbFalse,vbFalse) & ","
End Function

Function WriteID880Dup(freqOutput, freqInput)
    If CSng(freqOutput) > CSng(freqInput) Then
        WriteID880Dup = "DUP-,"
    ElseIf CSng(freqOutput) < CSng(freqInput) Then
        WriteID880Dup = "DUP+,"
    Else
        WriteID880Dup = "OFF,"
    End If
End Function

Function WriteID880Offset(freqOutput, freqInput)
    'This converts the offset producing no rounding issues
    'Convert string to a floating point Single (CSng), change MHz to Hz but multipling by 1000000.0, convert to a big integer (CLng)
    'Subtract the 2 big integers and change back to a floating point Single (CSng)
    'convert back to MHz by dividing by 1000000.0
    'strip of negative offsets these are handled by the duplex field
    'Convert it all back to a string
    'Voila
    WriteID880Offset = FormatNumber(Abs(CDbl(CLng(CDbl(freqOutput)*10000.0) - CLng(CDbl(freqInput)*10000.0))/10000.0),6,vbTrue,vbFalse,vbFalse) & ","
End Function

Function WriteID880TS(freqStep)
    WriteID880TS = freqStep & ","
End Function

Function WriteID880Mode(mode)
    WriteID880Mode = mode & ","
End Function

'You can space out the call sign to 8 chars if you wish and add a character in the 8th position (note overwrites)
Function WriteID880Name(callsign, suffix)
    If suffix = "" Then 'do nothing case
        WriteID880Name = callsign & ","
        Exit Function
    End if
    WriteID880Name = expandCallsign(callsign, suffix) & ","
End Function

'Expand out to at least 8 characters filing with spaces
'Position 8 can be overwritten
Function expandCallSign(callsign,suffix)
    dim expanded
    expanded = callsign & space(8)
    if suffix = "" Then
        expanded = Left(expanded , 8) 'suffix is empty so use the space
    Else
        expanded = Left(expanded , 7) 'hmm suffix MUST be only 1 char
    End If
    expandCallSign = expanded & suffix
End Function

Function WriteID880Skip()
    WriteID880Skip = "OFF,"
End Function

Function WriteID880Tone(tone)
    If tone = "-" Then
        WriteID880Tone = "OFF,"
    Else
        WriteID880Tone = "TONE,"
    End If
End Function

Function WriteID880RepeaterTone(tone)
    If tone = "-" Or tone = " " Or tone ="" Then 'tone is a little variable in the wia csv file
        WriteID880RepeaterTone = "88.5Hz,"
    Else
        WriteID880RepeaterTone = FormatNumber(CSng(tone),1,vbTrue,vbFalse,vbFalse) & "Hz," 'Looks like Tone must always have 1 character after the decimal point
    End If
End Function

Function WriteID880TSQFreq()
    WriteID880TSQFreq = "88.5Hz,"
End Function

Function WriteID880DTCSCode()
    WriteID880DTCSCode = "023,"
End Function

Function WriteID880DTCSPolarity()
    WriteID880DTCSPolarity = "BOTH N,"
End Function

Function WriteID880DTCSDVSQL()
    WriteID880DTCSDVSQL = "OFF,"
End Function

Function WriteID880DTCSDVSQLCode()
    WriteID880DTCSDVSQLCode = "0,"
End Function

Function WriteID880YourCallSign()
    WriteID880YourCallSign = "CQCQCQ,"
End Function

Function WriteID880RPT1CallSign(callsign)
    WriteID880RPT1CallSign = callsign &","
End Function

Function WriteID880RPT2CallSign(callsign)
    WriteID880RPT2CallSign = callsign 'Last field aways so no comma
End Function

Sub padoutTo100Lines(file, count)

    If count = 0 Then
        Exit Sub
    End If

    Dim i
    for i = 0 to count-1
        file.WriteLine(Right("00" & CStr(100-count+i),2) & ",,,,,,,,,,,,,,,,,")
    Next

End Sub
